<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwsplitpriorities="urn:WebWorks-Engine-Split-Priorities-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwmultisere="urn:WebWorks-XSLT-Extension-MultiSearchReplace"
                              exclude-result-prefixes="xsl msxsl wwsplits wwsplitpriorities wwmode wwfiles wwdoc wwproject wwvars wwpage wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwexsldoc wwmultisere"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterParcelType" />
 <xsl:param name="ParameterCopyType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:common/files/filter.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />
 <xsl:include href="wwformat:Transforms/connect_files.xsl" />


 <xsl:key name="wwproject-group-by-groupid" match="wwproject:Group" use="@GroupID" />
 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/filter.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/filter.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_files.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_files.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <!-- Project files -->
 <!--               -->
 <xsl:variable name="GlobalProjectFiles" select="wwfilesystem:GetFiles(wwprojext:GetProjectFilesDirectoryPath())" />
 <xsl:variable name="GlobalProjectFilesPaths">
  <xsl:for-each select="$GlobalProjectFiles/wwfiles:Files/wwfiles:File">
   <xsl:value-of select="@path" />
   <xsl:value-of select="':'" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectFilesChecksum" select="wwstring:MD5Checksum($GlobalProjectFilesPaths)" />


 <!-- Project files as splits -->
 <!--                         -->
 <xsl:variable name="GlobalProjectFilesSplitsAsXML">
  <xsl:call-template name="Connect-Project-Files-As-Splits">
   <xsl:with-param name="ParamProjectFiles" select="$GlobalProjectFiles" />
  </xsl:call-template>
 </xsl:variable>
 <xsl:variable name="GlobalProjectFilesSplits" select="msxsl:node-set($GlobalProjectFilesSplitsAsXML)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Get page template files -->
   <!--                         -->
   <xsl:variable name="VarPageTemplateFilesAsXML">
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
   <xsl:variable name="VarPageTemplateFilesPaths">
    <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
     <xsl:value-of select="@path" />
     <xsl:value-of select="':'" />
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

   <xsl:variable name="VarProgressConnectStart" select="wwprogress:Start(1)" />

   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />

   <!-- Up-to-date? -->
   <!--             -->
   <xsl:variable name="VarConnectPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetFormatSetting('connect-entry'))" />
   <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarConnectPath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups), ':', $VarPageTemplateFilesChecksum), '', '', concat($GlobalActionChecksum, ':', $GlobalProjectFilesChecksum))" />
   <xsl:if test="not($VarUpToDate)">
    <!-- Connect -->
    <!--         -->
    <xsl:variable name="VarResultAsXML">
     <xsl:call-template name="Connect">
      <xsl:with-param name="ParamPath" select="$VarConnectPath" />
      <xsl:with-param name="ParamVariables" select="$GlobalProjectVariables//wwvars:Variable" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
    <xsl:variable name="VarEncoding" select="wwprojext:GetFormatSetting('encoding', 'utf-8')" />
    <xsl:variable name="VarTempPath" select="wwfilesystem:GetTempFileName()" />
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarTempPath, $VarEncoding, 'html', '5.0', 'yes', 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />

    <!-- Use contextual navigation? -->
    <!--                            -->
    <xsl:variable name="VarNavigationWidth">
     <xsl:choose>
      <xsl:when test="wwprojext:GetFormatSetting('toc-generate') = 'true'">
       <xsl:value-of select="wwprojext:GetFormatSetting('connect-navigation-width')" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:text>0</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <!-- Configure script variables -->
    <!--                            -->
    <xsl:variable name="VarScriptReplacementsAsXML">
     <wwmultisere:Entry match="Connect.show_first_document = false;" replacement="Connect.show_first_document = {wwprojext:GetFormatSetting('show-first-document')};" />
     <wwmultisere:Entry match="Connect.navigation_width = 200;" replacement="Connect.navigation_width = {$VarNavigationWidth};" />
     <wwmultisere:Entry match="Connect.navigation_minimum_page_width = 800;" replacement="Connect.navigation_minimum_page_width = {wwprojext:GetFormatSetting('connect-navigation-minimum-page-width')};" />
     <wwmultisere:Entry match="Connect.disqus_id = '';" replacement="Connect.disqus_id = '{wwprojext:GetFormatSetting('social-disqus-id')}';" />
     <wwmultisere:Entry match="Connect.email = '';" replacement="Connect.email = '{wwprojext:GetFormatSetting('feedback-email', '')}';" />
    </xsl:variable>
    <xsl:variable name="VarScriptReplacements" select="msxsl:node-set($VarScriptReplacementsAsXML)/*" />
    <xsl:variable name="VarReplaceAllInFile" select="wwmultisere:ReplaceAllInFile($VarEncoding, $VarTempPath, $VarEncoding, $VarConnectPath, $VarScriptReplacements)" />
    <xsl:variable name="VarDeleteTempPath" select="wwfilesystem:DeleteFile($VarTempPath)" />
   </xsl:if>

   <wwfiles:File path="{$VarConnectPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarConnectPath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups), ':', $VarPageTemplateFilesChecksum)}" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $GlobalProjectFilesChecksum)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />

    <!-- Page Template Include Files -->
    <!--                             -->
    <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
     <xsl:variable name="VarFile" select="." />

     <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
    </xsl:for-each>
   </wwfiles:File>
   <xsl:variable name="VarProgressConnectEnd" select="wwprogress:End()" />

   <!-- Page Template Files -->
   <!--                     -->
   <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:GetDirectoryName($VarConnectPath)" />
   <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
    <xsl:variable name="VarPageTemplateFile" select="." />

    <!-- Get source and destination paths -->
    <!--                                  -->
    <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath(concat('wwformat:Pages/', $VarPageTemplateFile/@path))" />
    <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, $VarPageTemplateFile/@path)" />

    <!-- Copy -->
    <!--      -->
    <xsl:variable name="VarPageTemplateFileUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', '')" />
    <xsl:if test="not($VarPageTemplateFileUpToDate)">
     <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
    </xsl:if>

    <!-- Report Files -->
    <!--              -->
    <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterCopyType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="" category="" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
    </wwfiles:File>
   </xsl:for-each>

   <!-- Project files -->
   <!--               -->
   <xsl:for-each select="$GlobalProjectFilesSplits//wwsplits:File">
    <xsl:variable name="VarSplitsFile" select="." />

    <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath($VarSplitsFile/@source)" />

    <xsl:variable name="VarProjectFileUpToDate" select="wwfilesext:UpToDate($VarSplitsFile/@path, '', '', '', '')" />
    <xsl:if test="not($VarProjectFileUpToDate)">
     <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarSplitsFile/@path)" />
    </xsl:if>

    <wwfiles:File path="{$VarSplitsFile/@path}" type="{$ParameterCopyType}" checksum="{wwfilesystem:GetChecksum($VarSplitsFile/@path)}" projectchecksum="" groupID="" documentID="" actionchecksum="" category="" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
    </wwfiles:File>
   </xsl:for-each>

   <!-- Skin Sprite -->
   <!--             -->
   <xsl:variable name="VarSkinSpriteSourcePath" select="wwuri:AsFilePath('wwformat:Pages/images/skin.png')" />
   <xsl:variable name="VarSkinSpriteDestinationPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, 'connect/images/skin.png')" />
   <xsl:variable name="VarSkinSpriteFileUpToDate" select="wwfilesext:UpToDate($VarSkinSpriteDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSkinSpriteSourcePath))" />
   <xsl:if test="not($VarSkinSpriteFileUpToDate)">
    <xsl:variable name="VarCopySkinFileResult" select="wwfilesystem:CopyFile($VarSkinSpriteSourcePath, $VarSkinSpriteDestinationPath)" />
   </xsl:if>
   <wwfiles:File path="{$VarSkinSpriteDestinationPath}" type="{$ParameterCopyType}" checksum="{wwfilesystem:GetChecksum($VarSkinSpriteDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSkinSpriteSourcePath)}" category="" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$VarSkinSpriteSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSkinSpriteSourcePath)}" groupID="" documentID="" />
   </wwfiles:File>
  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Connect">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamVariables" />

  <!-- Page Rule -->
  <!--           -->
  <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', wwprojext:GetFormatSetting('connect-page-style'))" />

  <!-- Conditions -->
  <!--            -->
  <xsl:variable name="VarConditionsAsXML">
   <!-- TOC -->
   <!--     -->
   <xsl:if test="wwprojext:GetFormatSetting('toc-generate') = 'true'"> -->
    <wwpage:Condition name="toc-enabled" />
   </xsl:if> -->

   <!-- Index -->
   <!--       -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate') = 'true'">
    <wwpage:Condition name="index-enabled" />
   </xsl:if>

   <!-- Search -->
   <!--        -->
   <xsl:if test="wwprojext:GetFormatSetting('google-search') = 'true'">
    <wwpage:Condition name="search-enabled" />
   </xsl:if>

   <!-- Google Translation -->
   <!--                    -->
   <xsl:if test="wwprojext:GetFormatSetting('google-translate') = 'true'">
    <wwpage:Condition name="globe" />
    <wwpage:Condition name="google-translation-enabled" />
   </xsl:if>

   <!-- Company Info -->
   <!--              -->
   <xsl:call-template name="CompanyInfo-Conditions">
    <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

  <!-- Replacements -->
  <!--              -->
  <xsl:variable name="VarReplacementsAsXML">
   <!-- body-class -->
   <!--            -->
   <wwpage:Replacement name="body-class">
    <xsl:attribute name="value">
     <!-- Additional CSS classes -->
     <!--                        -->
     <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
     <xsl:value-of select="$VarAdditionalCSSClassesOption" />
    </xsl:attribute>
   </wwpage:Replacement>

   <!-- body-style -->
   <!--            -->
   <wwpage:Replacement name="body-style">
    <xsl:attribute name="value">
     <!-- CSS properties -->
     <!--                -->
     <xsl:variable name="VarCSSPropertiesAsXML">
      <xsl:call-template name="CSS-TranslateProjectProperties">
       <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
       <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamPath" />
       <xsl:with-param name="ParamSplits" select="$GlobalProjectFilesSplits" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

     <xsl:call-template name="CSS-InlineProperties">
      <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
     </xsl:call-template>
    </xsl:attribute>
   </wwpage:Replacement>

   <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
   <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

   <!-- Company Info -->
   <!--              -->
   <xsl:call-template name="CompanyInfo-Replacements">
    <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
    <xsl:with-param name="ParamPagePath" select="$ParamPath" />
    <xsl:with-param name="ParamSplits" select="$GlobalProjectFilesSplits" />
   </xsl:call-template>

   <!-- Variables -->
   <!--           -->
   <xsl:variable name="VarVariablesAsXML">
    <xsl:call-template name="Variables-Filter-Last-Unique">
     <xsl:with-param name="ParamVariables" select="$ParamVariables" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />
   <xsl:call-template name="Variables-Page-String-Replacements">
    <xsl:with-param name="ParamVariables" select="$VarVariables" />
   </xsl:call-template>

   <!-- Parcels -->
   <!--         -->
   <wwpage:Replacement name="parcels">
    <xsl:for-each select="$GlobalProject[1]">
     <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
     <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

     <xsl:call-template name="Parcels">
      <xsl:with-param name="ParamPath" select="$ParamPath" />
      <xsl:with-param name="ParamMergeSettings" select="$VarMergeSettings" />
     </xsl:call-template>
    </xsl:for-each>
   </wwpage:Replacement>
  </xsl:variable>
  <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

  <!-- Map common characters -->
  <!--                       -->
  <wwexsldoc:MappingContext>
   <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

   <!-- Invoke page template -->
   <!--                      -->
   <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
    <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
    <xsl:with-param name="ParamOutputDirectoryPath" select="wwfilesystem:GetDirectoryName($ParamPath)" />
    <xsl:with-param name="ParamOutputPath" select="$ParamPath" />
    <xsl:with-param name="ParamConditions" select="$VarConditions" />
    <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
   </xsl:apply-templates>
  </wwexsldoc:MappingContext>
 </xsl:template>


 <xsl:template name="Parcels">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamMergeSettings" />

  <!-- Process merge settings -->
  <!--                        -->
  <xsl:variable name="VarParcelsAsXML">
   <html:ul>
    <xsl:apply-templates select="$ParamMergeSettings" mode="wwmode:parcels">
     <xsl:with-param name="ParamPath" select="$ParamPath" />
    </xsl:apply-templates>
   </html:ul>
  </xsl:variable>
  <xsl:variable name="VarParcels" select="msxsl:node-set($VarParcelsAsXML)" />

  <!-- Filter empty parcels -->
  <!--                      -->
  <xsl:apply-templates select="$VarParcels" mode="wwmode:filter-parcels" />
 </xsl:template>


 <xsl:template name="VerifyGroup">
  <xsl:param name="ParamMergeGroup" />

  <xsl:for-each select="$GlobalProject[1]">
   <xsl:variable name="VarGroup" select="key('wwproject-group-by-groupid', $ParamMergeGroup/@GroupID)" />
   <xsl:variable name="VarGroupDocuments" select="$VarGroup/descendant::wwproject:Document" />

   <xsl:value-of select="count($VarGroupDocuments[1]) &gt; 0" />
  </xsl:for-each>
 </xsl:template>


 <!-- wwmode:parcels -->
 <!--                -->

 <xsl:template match="/" mode="wwmode:parcels">
  <xsl:param name="ParamPath" />

  <xsl:apply-templates mode="wwmode:parcels">
   <xsl:with-param name="ParamPath" select="$ParamPath" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwproject:TOC" mode="wwmode:parcels">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamTOC" select="." />

  <html:li>
   <html:div class="ww_skin_toc_entry ww_skin_toc_folder">
    <!-- No break -->
    <!--          -->
    <wwexsldoc:NoBreak />

    <!-- Expand/collapse -->
    <!--                 -->
    <html:span class="ww_skin ww_skin_toc_dropdown ww_skin_toc_dropdown_closed">
     <xsl:text>&#160;</xsl:text>
    </html:span>

    <xsl:value-of select="$ParamTOC/@Name" />
   </html:div>

   <html:ul>
    <xsl:apply-templates mode="wwmode:parcels">
     <xsl:with-param name="ParamPath" select="$ParamPath" />
    </xsl:apply-templates>
   </html:ul>
  </html:li>
 </xsl:template>


 <xsl:template match="wwproject:MergeGroup" mode="wwmode:parcels">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamMergeGroup" select="." />

  <xsl:variable name="VarIncludeGroup">
   <xsl:call-template name="VerifyGroup">
    <xsl:with-param name="ParamMergeGroup" select="$ParamMergeGroup" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:if test="$VarIncludeGroup = 'true'">
   <xsl:for-each select="$GlobalProject[1]">
    <html:li>
     <html:div class="ww_skin_toc_entry ww_skin_toc_folder">
      <!-- No break -->
      <!--          -->
      <wwexsldoc:NoBreak />

      <!-- Expand/collapse -->
      <!--                 -->
      <html:span class="ww_skin ww_skin_toc_dropdown ww_skin_toc_dropdown_closed">
       <xsl:text>&#160;</xsl:text>
      </html:span>

      <!-- Determine parcel context -->
      <!--                          -->
      <xsl:variable name="VarParcelContext">
       <xsl:call-template name="Connect-Context">
        <xsl:with-param name="ParamProject" select="$GlobalProject" />
        <xsl:with-param name="ParamGroupID" select="$ParamMergeGroup/@GroupID" />
       </xsl:call-template>
      </xsl:variable>

      <!-- Locate parcel page path -->
      <!--                         -->
      <xsl:for-each select="$GlobalFiles[1]">
       <xsl:variable name="VarParcelFile" select="key('wwfiles-files-by-type', $ParameterParcelType)[@groupID = $ParamMergeGroup/@GroupID]" />
       <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($ParamMergeGroup/@GroupID)" />

       <!-- Determine parcel title -->
       <!--                        -->
       <xsl:variable name="VarGroupTitle">
        <xsl:choose>
         <xsl:when test="string-length($ParamMergeGroup/@Title) &gt; 0">
          <xsl:value-of select="$ParamMergeGroup/@Title" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="$VarGroupName" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <html:a id="{$VarParcelContext}:{$ParamMergeGroup/@GroupID}" href="{wwuri:GetRelativeTo($VarParcelFile/@path, $ParamPath)}" target="_self" title="{$VarGroupTitle}"><xsl:value-of select="$VarGroupTitle" /></html:a>
      </xsl:for-each>
     </html:div>
    </html:li>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:parcels">
  <xsl:param name="ParamPath" />

  <xsl:apply-templates mode="wwmode:parcels">
   <xsl:with-param name="ParamPath" select="$ParamPath" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:parcels">
  <xsl:param name="ParamPath" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- wwmode:filter-parcels -->
 <!--                       -->

 <xsl:template match="/" mode="wwmode:filter-parcels">
  <xsl:apply-templates mode="wwmode:filter-parcels" />
 </xsl:template>


 <xsl:template match="html:ul" mode="wwmode:filter-parcels">
  <xsl:param name="ParamList" select="." />

  <!-- Contains child links? -->
  <!--                       -->
  <xsl:variable name="VarContainsChildLinks" select="count($ParamList//html:a[1]) &gt; 0" />

  <!-- Keep it? -->
  <!--          -->
  <xsl:if test="$VarContainsChildLinks">
   <xsl:copy>
    <xsl:copy-of select="@*" />

    <xsl:apply-templates mode="wwmode:filter-parcels" />
   </xsl:copy>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:filter-parcels">
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates mode="wwmode:filter-parcels" />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:filter-parcels">
  <xsl:copy />
 </xsl:template>
</xsl:stylesheet>
